function [beta_final,lamda_error,fval_out] = L1(train_in,test_in,log2lamda_in)

% Using linprog in L1 norm
% Read in the training, tuning, testing and log2lamda data
% Return tables for a list of lamda

    global k;
    global d;
    global d1;
    
    % get input argument
    train = train_in;
    train_data = train(:,2:end);
    [row_train,col_train] = size(train_data);
    log2lamda = log2lamda_in;
    num_lamda = length(log2lamda);
    my_lamda = power(2,log2lamda);   
    
    % initialize output argument and others
    beta_all = zeros(1+2*k*d+row_train+1,num_lamda);
    beta_final = zeros(1+k*d,num_lamda);
    lamda_error = zeros(num_lamda,4); % have 5 columns: log2lamda,error,exit_flag,#iteration,minimum
    lamda_error(:,1) = log2lamda;
    
    % generate A matrix
    data1 = [train(:,1), repmat(train_data, 1, 2*k), ones(row_train,row_train)];
    data1_data = data1(:,2:end);
    A = []; % A[(k-1)*row_train,2*k*d+row_train] 
    for i = 1:row_train
      label = data1(i,1);
      for j = 1:k 
        if label==j
        else
            temp = zeros(1,2*k*d+row_train);
            temp(1,(j-1)*d+1:j*d) = 1;
            temp(1,(k+j-1)*d+1:(k+j)*d) = -1;
            temp(1,(label-1)*d+1:label*d) = -1;
            temp(1,(k+label-1)*d+1:(k+label)*d) = 1;
            temp(1,2*k*d+i) = -1;
            A = [A; data1_data(i,:).*temp];
        end
      end
    end    
    A = sparse(A);
    
    % sum to zeros constraints
    diag_vec = ones(d,1);
    temp = diag(diag_vec);
    temp2 = diag(diag_vec*(-1));
    Aeq = [repmat(temp,1,k),repmat(temp2,1,k),zeros(d,row_train)];
    beq = zeros(d,1);

    % generate other vectors      
    b = ones(row_train*(k-1), 1)*(-1);
    lb = zeros(2*k*d+row_train,1);
    ub = [];
    xstart = [];    
    
    for i = 1:num_lamda
        
        pre_f = [zeros(1,1);ones(d1,1)];
        f = [repmat(pre_f,2*k,1)*my_lamda(i,1); ones(row_train,1)];

        [x,fvalue,exitflag,output] = linprog(f,A,b,Aeq,beq,lb);

        beta_all(:,i) = [log2lamda(i,1);x;fvalue];
        beta = x(1:k*d) - x(k*d+1:2*k*d);
        beta_final(:,i) = [log2lamda(i,1);beta];

        lamda_error(i,3) = exitflag;
        lamda_error(i,4) = output.iterations;
                
        % testing on the tune data set
        [fval,tune_error] = test(beta,test_in);               
        lamda_error(i,2) = tune_error;

    end
    
    [Y,index] = min(lamda_error(:,2));
    lamda_error(:,5) = 0;
    lamda_error(index,5) = 1;

    % testing on the testing data set
    [fval,test_error] = test(beta_all(2:k*d+1,index),test_in);               
    fval_out = fval;
    min_vector = [log2lamda(index);my_lamda(index);test_error;lamda_error(index,3);beta_all(2:end,index);];
